<?php
require __DIR__ . '/config.php';
cors();

// Deteksi bot
if (is_bot_ua($_SERVER['HTTP_USER_AGENT'] ?? '')) {
  header('Content-Type: text/plain; charset=utf-8');
  echo "OK";
  exit;
}

// Ambil parameter akses (login / daftar)
$akses = $_GET['akses'] ?? 'login';
$key = ($akses === 'daftar') ? 'daftar' : 'login';

// Ambil data dari file JSON
$data = read_data();
$list = $data[$key] ?? [];

// Kalau kosong, kasih pesan error
if (!$list) {
  http_response_code(503);
  echo "No link configured for " . htmlspecialchars($key);
  exit;
}

// Pilih link acak
$target = $list[array_rand($list)];
header('Location: ' . $target, true, 302);
exit;
